<?php
require_once "./config.php";
?>
<!DOCTYPE html>
<html lang="en">
<?php require_once "./head.php"; ?>

<body>
    <?php require_once "./header.php"; ?>
    <style>
        .table-container, .table-body {
            padding: 20px !important;
        }
    </style>
    
    <!-- Main content -->
    <div class="content">
        <!-- Page header -->
        <div class="page-header">
            <h1 class="page-title">Forecast for sku #<?php echo $_GET['sku']; ?><?php                 
                $sql="SELECT * FROM skus WHERE sku='".$_GET['sku']."' LIMIT 1;";
                $ejecutarquery=mysqli_query($link,$sql);
                if(mysqli_num_rows($ejecutarquery)>0){
                    $row=mysqli_fetch_assoc($ejecutarquery);
                    echo " - ".$row['name'];
                }
            ?></h1>
            <div class="botonera">
                <!--<button class="success" id="addBtn">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <line x1="12" y1="5" x2="12" y2="19"></line>
                        <line x1="5" y1="12" x2="19" y2="12"></line>
                    </svg>
                    Add User
                </button>
                <button id="importCsvBtn">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path>
                        <polyline points="17 8 12 3 7 8"></polyline>
                        <line x1="12" y1="3" x2="12" y2="15"></line>
                    </svg>
                    Import from CSV
                </button>
                <button id="exportCsvBtn">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path>
                        <polyline points="7 10 12 15 17 10"></polyline>
                        <line x1="12" y1="15" x2="12" y2="3"></line>
                    </svg>
                    Export to CSV
                </button>-->
            </div>
        </div>
        <!-- Table container -->
        <div class="table-container" style="overflow: auto;">
<?php
    if(isset($_GET['sku']) ){
        $endpoint="https://preview3.alexcd2000.com/endpoint_mockup/".$_GET['sku'].".json";
        $demanda = @file_get_contents($endpoint);
        if ($demanda === false) {
            echo "API Endpoint Error";
            exit;
        }
        //echo $endpoint;echo "<br><br>";echo $demanda;

        $demandaAPI=json_decode($demanda,true);
        require_once "./forecast-algoritmo.php";

        if(isset($_GET['group']) ){//"mes" o n dias
            $demanda = prepararDatos($demandaAPI, $_GET['group']);  
        }
        //echo implode(", ", $demandaAPI["historico"])."<hr>".implode(", ", $demanda)."<hr>";
    
        // Asume que ya se aplicó prepararDatos()
        $valores = $demanda; // este es el array numérico de demanda agrupada
        $original = $demandaAPI; // o la fuente original de $demanda

        // Extraer fechas de inicio y fin desde el histórico original
        $fechas = array_keys($original["historico"]);
        sort($fechas);
        $fecha_inicio = reset($fechas);
        $fecha_fin = end($fechas);

        // Calcular estadísticas
        $cantidad = count($valores);
        $min = min($valores);
        $max = max($valores);
        $promedio = round(array_sum($valores) / $cantidad, 2);
        $media = round($valores[floor($cantidad / 2)], 2);
        $desviacion = round(sqrt(array_sum(array_map(function ($v) use ($promedio) {
            return pow($v - $promedio, 2);
        }, $valores)) / $cantidad), 2);

        $stock_actual = $original["stock_actual"] ?? "—";

        // Calcular rangos gaussianos
        $rango_1 = round($promedio - $desviacion, 2) . " to " . round($promedio + $desviacion, 2);
        $rango_2 = round($promedio - 2 * $desviacion, 2) . " to " . round($promedio + 2 * $desviacion, 2);

        if($cantidad > 1){
            echo "<table border='1' cellpadding='6' cellspacing='0' style='border-collapse: collapse; font-family: sans-serif; width: 100%;'>";
            //echo "<thead style='background-color:#f2f2f2;'><tr><th colspan='4'>Data Summary</th></tr></thead><tbody>";
            echo "<tr><th>Start Date</th><td>$fecha_inicio</td><th>End Date</th><td>$fecha_fin</td></tr>";
            echo "<tr><th>Current Stock</th><td>$stock_actual</td><th>Number of elements</th><td>$cantidad, grouped by ".$_GET['group']."</td></tr>";
            echo "<tr><th>Minimum Value</th><td>$min</td><th>Maximum Value</th><td>$max</td></tr>";
            echo "<tr><th>Average</th><td>$promedio</td><th>Median</th><td>$media</td></tr>";
            echo "<tr><th>95% of the time (±2σ)</th><td>$rango_2</td><th>68% of the time (±1σ)</th><td>$rango_1</td></tr>";
            echo "<tr><th>Standard Deviation (σ)</th><td colspan='3'>$desviacion</td></tr>";
            echo "</tbody></table><br>";

            $resultados=calcular_todos_los_modelos($demanda);
            //echo "<hr><pre>";var_dump($resultados);echo "</pre><hr>";
            mostrar_tabla_modelos($resultados);        
            graficar_tabla_modelos($resultados, $demanda, $original, $_GET['group']);

            require_once "./assets/libraries/chatgpt.php";
            echo "<hr style='width:50%; margin: 20px 25%;'>";
            echo "<h3>AI Recommendation & interpretation:</h3>";
            chatgpt_modelos($resultados);        
        }else{
            echo "ERROR: Need at least 2 elements";            
        }
        
    }else{
        echo "No SKU selected";
    }
?>

        </div>
    </div>
    <?php require_once "./footer.php"; ?>
    <!--Pagination here-->
    <?php if(isset($alert) ){ echo '<script>alert(" '.$alert.' ")</script>'; } ?>
</body>

</html>